%%% "Modeling changes in US monetary policy using a time-varying nonlinear
%%% Taylor rule"
%%% Nguyen, Pavlidisz, and Peel
%************************************************************************

% This file is first to construct the expected inflation variance, and then
% to estimate time-invariant parameters of the models. The estimates will
% be saved and be called by the Run_file_TVP_estimate to estimate
% time-vaying parameters of the model.

clc
clear all

%% CONSTRUCT THE EXPECTED INFLATION VARIANCE

Realtime_Forecasts;

%% ESTIMATE TIME_INVARIANT PARAMETERS

global seed
seed=1;

% Initial values for the log of std
sig_sig=-1; sig_rho=-1; sig_c=-1; sig_a=-1; sig_b=3; sig_d=-1;
param0=[sig_sig sig_rho sig_c sig_a sig_b sig_d]';

% Large std reflecting uncertainty with these initial values
sigma_cm=2+zeros(6,1);

% Estimation using CMAES-optimization based
     [xmin, ...      % minimum search point of last iteration
	  fmin, ...      % function value of xmin
	  counteval, ... % number of function evaluations done
	  stopflag, ...  % stop criterion reached
	  out, ...     % struct with various histories and solutions
	  bestever ... % struct containing overall best solution (for convenience)
	 ] = fcmaes( ...
    'rule_nonlinear_lk_RW', ...    % name of objective/fitness function   
    param0,sigma_cm); %,opts

load('variablescmaes.mat');

stdxmean=sigma*sqrt(diagC);

save Estimates_results_save xmean stdxmean

